/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.call.options;

import com.huawei.mobilePartner.business.call.common.CommonConfigCallInfo;
import com.huawei.mobilePartner.business.call.options.CallCueEvent;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CallCueOperation {
    private static CallCueOperation instance = null;
    private String configXmlPath = "";
    public LogConfig log = Log.getLog(CallCueOperation.class);

    public static CallCueOperation getInstance() {
        if (instance == null) {
            instance = new CallCueOperation();
        }
        return instance;
    }

    private CallCueOperation() {
        this.configXmlPath = CommonConfigCallInfo.getInstance().getClassPath();
    }

    public void saveCueMode(CallCueEvent callCue) {
        String[] nodePropertiesValue;
        XMLTool comm = null;
        CallCueEvent callConfigCue = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("The path of delete file: " + this.configXmlPath + "config/data/CallCue.xml");
            comm = new XMLTool("config/data/CallCue.xml", "callcue");
            callConfigCue = this.listToCueEvent();
        }
        catch (Exception ex) {
            this.log.error("read config/data/CallCue.xml fail : [" + ex.toString() + "]");
        }
        if (callConfigCue.getVisionCue() == null) {
            nodePropertiesValue = new String[]{"vision", "true"};
            comm.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue);
        }
        if (callConfigCue.getVisionCue() == null) {
            nodePropertiesValue = new String[]{"ear", "true"};
            comm.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue);
        }
        if (callConfigCue.getVisionCue() == null) {
            String soundFile = String.valueOf(this.configXmlPath) + "config/images/CallUIPlugin/callvoice.wav";
            String[] nodePropertiesValue2 = new String[]{"earpath", soundFile};
            comm.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue2);
        }
        this.updateCueNodeContent(comm, callCue.getVisionCue(), "vision");
        this.updateCueNodeContent(comm, callCue.getEarCue(), "ear");
        this.updateCueNodeContent(comm, callCue.getEarCuePath(), "earpath");
    }

    private void updateCueNodeContent(XMLTool comm, String value, String name) {
        String callNodeProPath = "callcue/cue[@name=\"";
        callNodeProPath = String.valueOf(callNodeProPath) + name + "\"]";
        String[] proValue = new String[]{name, value};
        Tools.logToControl("out", callNodeProPath);
        comm.updateNodeMultiPropertiesValue(callNodeProPath, CommonConfigCallInfo.PRO_NAME, proValue);
    }

    private List getCallCueMode() {
        List list = new ArrayList();
        String[] proName = new String[]{"name", "value"};
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(false);
            this.log.info("The path of delete file: " + this.configXmlPath + "config/data/CallCue.xml");
            comm = new XMLTool("config/data/CallCue.xml");
            list = comm.quertyNodePropertiesValueByPath("callcue/cue", proName);
        }
        catch (Exception ex) {
            this.log.error("read CallCue.xml fail : [" + ex.toString() + "]");
        }
        return list;
    }

    public CallCueEvent listToCueEvent() {
        CallCueEvent callCue = new CallCueEvent();
        List callCueList = this.getCallCueMode();
        int index = 0;
        while (index < callCueList.size()) {
            HashMap cueMap = (HashMap)callCueList.get(index);
            if ("vision".equals(cueMap.get("name"))) {
                callCue.setVisionCue(cueMap.get("value").toString());
            }
            if ("ear".equals(cueMap.get("name"))) {
                callCue.setEarCue(cueMap.get("value").toString());
            }
            if ("earpath".equals(cueMap.get("name"))) {
                callCue.setEarCuePath(cueMap.get("value").toString());
            }
            ++index;
        }
        return callCue;
    }

    public void createCallCueXml() {
        String visionCue = "";
        String earCue = "";
        String soundFile = "";
        String path = "config/data/CallCue.xml";
        try {
            String[] nodePropertiesValue;
            XMLTool xmlTool = new XMLTool(path, "callcue");
            CallCueEvent callCue = this.listToCueEvent();
            visionCue = callCue.getVisionCue();
            earCue = callCue.getEarCue();
            soundFile = callCue.getEarCuePath();
            if (visionCue == null) {
                visionCue = "true";
                nodePropertiesValue = new String[]{"vision", visionCue};
                xmlTool.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue);
            } else if (!"true".equals(visionCue) && !"false".equals(visionCue)) {
                visionCue = "true";
                this.updateCueNodeContent(xmlTool, visionCue, "vision");
            }
            if (earCue == null) {
                earCue = "true";
                nodePropertiesValue = new String[]{"ear", earCue};
                xmlTool.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue);
            } else if (!"true".equals(earCue) && !"false".equals(earCue)) {
                earCue = "true";
                this.updateCueNodeContent(xmlTool, earCue, "ear");
            }
            if (soundFile == null) {
                soundFile = String.valueOf(this.configXmlPath) + "config/images/CallUIPlugin/callvoice.wav";
                nodePropertiesValue = new String[]{"earpath", soundFile};
                xmlTool.createNodeMultiPropertiesValue("callcue/cue", CommonConfigCallInfo.PRO_NAME, nodePropertiesValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

