/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.apn;

import com.huawei.mobilePartner.business.apn.ConfigParameter;
import com.huawei.mobilePartner.business.device.DeviceService;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InitializationAPN {
    private static final int FUNCTION_NODE = 3;
    private static final String COMMON_NAME = "common";
    private String cdmaType = "WCDMA";
    private XMLTool netConfigXml = null;
    private XMLTool profileLibXML = null;
    private XMLTool sysProfileXML = null;
    private XMLTool sysConfigXML = null;
    public static String apnNodeGroupPath = "utpsdoc[@type=\"Profile\"]/ProfileGroup[@type=\"DialUp\"]/Profile";
    public static String apnNodeDefaultPath = "utpsdoc[@type=\"Profile\"]/Default";
    public static final String operatorNodePath = "SysConfig/customize";
    public static String apnNodeProNetPath = "utpsdoc[@type=\"config\"]/group[@name=\"common\"]/module";
    public LogConfig log = null;
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";
    private final String dailupReqClose = "0";

    public InitializationAPN() {
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
        this.log = Log.getLog(InitializationAPN.class);
        try {
            XMLTool.setImportExport(false);
            this.sysConfigXML = new XMLTool("config/data/RunInfo.xml");
            this.netConfigXml = new XMLTool("config/data/NetConnectConfig.xml");
            this.profileLibXML = new XMLTool("config/data/ProfileLib.xml");
            this.sysProfileXML = new XMLTool("config/data/SysProfile.xml");
        }
        catch (Exception ex) {
            this.log.info("read NetConnectConfig.xml fail : [" + ex.toString() + "]");
        }
    }

    private String getSysConfigOperator() {
        String[] operator = new String[]{"operator"};
        String operStr = "";
        List operList = this.sysConfigXML.quertyNodePropertiesValueByPath(operatorNodePath, operator);
        int index = 0;
        while (index < operList.size()) {
            HashMap map = (HashMap)operList.get(index);
            operStr = map.get("operator").toString();
            ++index;
        }
        return operStr;
    }

    public List getApnParameter(String apnNodePath, String[] propertiesNames) {
        List resultList = this.netConfigXml.quertyNodePropertiesValueByPath(apnNodePath, propertiesNames);
        ArrayList<ConfigParameter> configList = new ArrayList<ConfigParameter>();
        Tools.logToControl("err", "resultList:[" + resultList + "]");
        int i = 0;
        while (i < resultList.size()) {
            HashMap map = (HashMap)resultList.get(i);
            ConfigParameter config = new ConfigParameter();
            if (propertiesNames.length == 3) {
                config.setName(map.get("name").toString());
                config.setValue(map.get("value").toString());
                config.setType(map.get("type").toString());
            } else {
                config.setName(map.get("name").toString());
                config.setValue(map.get("value").toString());
            }
            configList.add(config);
            ++i;
        }
        return configList;
    }

    public List getApnParameterIMSI(String apnNodePath, String[] propertiesNames) {
        List resultList = this.netConfigXml.quertyNodePropertiesValueByPath(apnNodePath, propertiesNames);
        ArrayList<ConfigParameter> configList = new ArrayList<ConfigParameter>();
        Tools.logToControl("err", "resultList:[" + resultList + "]");
        int i = 0;
        while (i < resultList.size()) {
            HashMap map = (HashMap)resultList.get(i);
            ConfigParameter config = new ConfigParameter();
            config.setImsi(map.get("imsi").toString());
            configList.add(config);
            ++i;
        }
        return configList;
    }

    public String itemStrPath(String leafage) {
        StringBuffer netPath = new StringBuffer();
        netPath.append("utpsdoc/group/module[@name=\"");
        netPath.append(this.wcdmaOrcdma());
        netPath.append("\"]/");
        netPath.append(leafage);
        return netPath.toString();
    }

    public String packStrPath(String leafage) {
        StringBuffer netPath = new StringBuffer();
        netPath.append("utpsdoc/group/module[@name=\"");
        if (COMMON_NAME.equals(this.getSysConfigOperator())) {
            netPath.append(this.wcdmaOrcdma());
        } else {
            netPath.append(this.getSysConfigOperator());
        }
        netPath.append("\"]/");
        netPath.append(leafage);
        return netPath.toString();
    }

    private List getSpecifyNodeValue() {
        ArrayList<List> specifyList = new ArrayList<List>();
        List templateList = this.getApnParameter(this.itemStrPath("ProfileTemplate/item"), ConfigInterface.PROPERTIES_NAME);
        List profileList = this.getApnParameter(this.packStrPath("ProfileList/item"), ConfigInterface.PROPERTIES_NAME);
        List functionList = this.getApnParameter(this.packStrPath("Function/item"), ConfigInterface.FUNCTION_NAME);
        specifyList.add(templateList);
        specifyList.add(profileList);
        specifyList.add(functionList);
        Tools.logToControl("err", "==============specifyList==============:[" + specifyList + "]");
        return specifyList;
    }

    private String wcdmaOrcdma() {
        this.cdmaType = DeviceService.getInstance().getProductNetType();
        String urlTemp = "";
        urlTemp = this.cdmaType == null || this.cdmaType.equalsIgnoreCase("wcdma") ? "WCDMA" : "CDMA";
        return urlTemp;
    }

    public void netConnectToSysProfile() {
        this.deleteProfileNode("DialUp");
        this.deleteProfileNode("WLAN");
        List allNodeList = this.getSpecifyNodeValue();
        int i = 0;
        while (i < allNodeList.size()) {
            List moduleList = (List)allNodeList.get(i);
            if (moduleList.size() > 0) {
                switch (i) {
                    case 0: {
                        ConfigParameter config;
                        int j = 0;
                        while (j < moduleList.size()) {
                            config = (ConfigParameter)moduleList.get(j);
                            this.templateToSysProfile(config);
                            ++j;
                        }
                        break;
                    }
                    case 1: 
                    case 3: {
                        ConfigParameter config;
                        int j = 0;
                        while (j < moduleList.size()) {
                            config = (ConfigParameter)moduleList.get(j);
                            this.profileToSysProfile(config);
                            ++j;
                        }
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void deleteProfileNode(String dialUpStr) {
        try {
            StringBuffer strPath = new StringBuffer();
            strPath.append("utpsdoc/ProfileGroup[@type=\"");
            strPath.append(dialUpStr);
            strPath.append("\"]/Profile");
            this.sysProfileXML.deleteNode(strPath.toString());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void profileToSysProfile(ConfigParameter config) {
        if (config.getValue().equals("default")) {
            String[] name = new String[]{"name", "type"};
            String[] value = new String[]{config.getName(), config.getType()};
            this.sysProfileXML.createOrUpdateChildNodeMultiProValByXpath("utpsdoc/Default", "utpsdoc/Default", name, value);
        }
        if (config.getName().trim().equals("huawei")) {
            return;
        }
        StringBuffer strPath = new StringBuffer();
        strPath.append("utpsdoc/ProfileGroup[@type=\"");
        strPath.append(config.getType());
        strPath.append("\"]/Profile[@name=\"");
        strPath.append(config.getName());
        strPath.append("\"]");
        String[] proName = ConfigInterface.APN_PROPERTIES_NAME;
        String cfgRequest = CustomizeInit.getCustomizeBean().getProfile_request_con();
        if (!"0".equals(cfgRequest)) {
            proName = ConfigInterface.APN_PROPERTIES_NAME_REQUEST;
        }
        String[] proValue = new String[proName.length];
        List profileList = this.profileLibXML.quertyNodePropertiesValueByPath(strPath.toString(), proName);
        int i = 0;
        while (i < profileList.size()) {
            HashMap profileMap = (HashMap)profileList.get(i);
            int j = 0;
            while (j < proName.length) {
                proValue[j] = profileMap.get(proName[j]) == null ? "" : profileMap.get(proName[j]).toString();
                ++j;
            }
            ++i;
        }
        StringBuffer profilePath = new StringBuffer();
        profilePath.append("utpsdoc[@type=\"Profile\"]/ProfileGroup[@type=\"");
        profilePath.append(config.getType());
        profilePath.append("\"]");
        this.sysProfileXML.createChildNodeMultiPropertiesValueByXpath(profilePath.toString(), "Profile", proName, proValue);
    }

    private void templateToSysProfile(ConfigParameter config) {
        try {
            this.sysProfileXML.updateNodePropertiesValue("utpsdoc/ProfileGroup[@type=\"DialUp\"]/Template", config.getName(), config.getValue());
        }
        catch (Exception e) {
            this.log.info("update node parameter fail : [" + e.toString() + "]");
        }
    }

    public boolean isFunctionEnabled(String functionName) {
        boolean m_bResult = false;
        List functionList = this.getApnParameter(this.packStrPath("Function/item"), ConfigInterface.FUNCTION_NAME);
        int i = 0;
        while (i < functionList.size()) {
            ConfigParameter functionConfig = (ConfigParameter)functionList.get(i);
            if (functionName.equals(functionConfig.getName())) {
                if (!"true".equals(functionConfig.getValue())) break;
                m_bResult = true;
                break;
            }
            ++i;
        }
        return m_bResult;
    }

    public String getIMSIAPNName() {
        String strIMSIAPNName = "";
        String strTempSimIMSI = "";
        String strMatchIMSI = "";
        if (!ConfigInterface.imsiString.equals("")) {
            String imsi = "";
            int nIMSILength = 0;
            List imsiProfile = this.getApnParameterIMSI(this.packStrPath("IMSIProfileList"), ConfigInterface.imsiProfile);
            int imsiIndex = 0;
            while (imsiIndex < imsiProfile.size()) {
                ConfigParameter config = (ConfigParameter)imsiProfile.get(imsiIndex);
                imsi = config.getImsi();
                if (imsi.equals(strTempSimIMSI = ConfigInterface.imsiString.substring(0, nIMSILength = imsi.length()))) {
                    strMatchIMSI = imsi;
                    break;
                }
                ++imsiIndex;
            }
            if (!"".equals(strMatchIMSI)) {
                String tempString = "IMSIProfileList[@imsi=\"" + strMatchIMSI + "\"]/item";
                Tools.logToControl("err", "==============tempString==============:[" + tempString + "]");
                List IMSIProfileList = this.getApnParameter(this.packStrPath(tempString), ConfigInterface.PROPERTIES_NAME);
                strIMSIAPNName = ((ConfigParameter)IMSIProfileList.get(0)).getName();
            }
        }
        return strIMSIAPNName;
    }
}

