/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.apn;

import com.huawei.mobilePartner.business.apn.APNEvent;
import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InitAPNManagement {
    private XMLTool sysProfileXML;
    public LogConfig log = null;
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";
    private final String dailupReqClose = "0";

    public InitAPNManagement() {
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
    }

    public List queryAPNInitParameter(String nodePath, String xmlFilePath) {
        String[] proName = ConfigInterface.APN_PROPERTIES_NAME;
        String cfgRequest = CustomizeInit.getCustomizeBean().getProfile_request_con();
        if (!"0".equals(cfgRequest)) {
            proName = ConfigInterface.APN_PROPERTIES_NAME_REQUEST;
        }
        this.log = Log.getLog(InitAPNManagement.class);
        List profileList = new ArrayList();
        ArrayList<APNEvent> listNodeValue = new ArrayList<APNEvent>();
        try {
            XMLTool.setImportExport(true);
            this.sysProfileXML = new XMLTool(xmlFilePath);
            profileList = this.sysProfileXML.quertyNodePropertiesValueByPath(nodePath, proName);
            int i = 0;
            while (i < profileList.size()) {
                HashMap profileMap = (HashMap)profileList.get(i);
                APNEvent apnEvent = new APNEvent();
                int j = 0;
                while (j < proName.length) {
                    String strProValue;
                    String string = strProValue = profileMap.get(proName[j]) == null ? "" : profileMap.get(proName[j]).toString().trim();
                    if (proName[j].equals("name")) {
                        apnEvent.setNetworkName(strProValue);
                    }
                    if (proName[j].equals("type")) {
                        apnEvent.setProfType(strProValue);
                    }
                    if (proName[j].equals("readonly")) {
                        apnEvent.setReadOnly(strProValue);
                    }
                    if (proName[j].equals("user")) {
                        apnEvent.setUsername(strProValue);
                    }
                    if (proName[j].equals("password")) {
                        apnEvent.setPassword(strProValue);
                    }
                    if (proName[j].equals("phonenumber")) {
                        apnEvent.setPhoneNumber(strProValue);
                    }
                    if (proName[j].equals("autoapn")) {
                        apnEvent.setApnFlag(strProValue);
                    }
                    if (proName[j].equals("apn")) {
                        apnEvent.setApn(strProValue);
                    }
                    if (proName[j].equals("chap")) {
                        apnEvent.setChap(strProValue);
                    }
                    if (proName[j].equals("ip")) {
                        if ("".equals(strProValue)) {
                            apnEvent.setIpFlag("true");
                            apnEvent.setIp("");
                        } else {
                            apnEvent.setIpFlag("false");
                            apnEvent.setIp(strProValue);
                        }
                    }
                    if (proName[j].equals("dns")) {
                        if ("".equals(strProValue)) {
                            apnEvent.setDnsFlag("true");
                            apnEvent.setDnsPreferred(strProValue);
                        } else {
                            apnEvent.setDnsFlag("false");
                            apnEvent.setDnsPreferred(strProValue);
                        }
                    }
                    if (proName[j].equals("dnsalt")) {
                        apnEvent.setDnsStandby(strProValue);
                    }
                    if (proName[j].equals("wins")) {
                        if ("".equals(strProValue)) {
                            apnEvent.setWinsFlag("true");
                            apnEvent.setWinsPreferred(strProValue);
                        } else {
                            apnEvent.setWinsFlag("false");
                            apnEvent.setWinsPreferred(strProValue);
                        }
                    }
                    if (proName[j].equals("winsalt")) {
                        apnEvent.setWinsStandby(strProValue);
                    }
                    if (proName[j].equals("request")) {
                        apnEvent.setDialupRequest(strProValue);
                    }
                    ++j;
                }
                this.log.debug(apnEvent.toString());
                listNodeValue.add(apnEvent);
                ++i;
            }
            this.sysProfileXML = null;
            return listNodeValue;
        }
        catch (Exception ex) {
            this.log.info("read xml fail : [" + ex.toString() + "]");
            this.sysProfileXML = null;
            return listNodeValue;
        }
    }

    public List getUserOrSystemProfile(String nodePath) {
        ArrayList listUserOrSystem = new ArrayList();
        StringBuffer sysNodePath = new StringBuffer();
        sysNodePath.append(nodePath);
        this.addNodeToList(listUserOrSystem, sysNodePath, String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/UserProfile.xml");
        this.addNodeToList(listUserOrSystem, sysNodePath, "config/data/SysProfile.xml");
        Collections.sort(listUserOrSystem, Collections.reverseOrder());
        return listUserOrSystem;
    }

    public List getUserOrSystemDefaultProfile(String nodePath) {
        ArrayList listUserOrSystem = new ArrayList();
        StringBuffer sysNodePath = new StringBuffer();
        sysNodePath.append(nodePath);
        this.addNodeToList(listUserOrSystem, sysNodePath, String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/UserProfile.xml");
        if (listUserOrSystem.size() <= 0) {
            this.addNodeToList(listUserOrSystem, sysNodePath, "config/data/SysProfile.xml");
        }
        Collections.sort(listUserOrSystem, Collections.reverseOrder());
        return listUserOrSystem;
    }

    public List getUserProfile(String nodePath) {
        ArrayList listUserProfileList = new ArrayList();
        StringBuffer sysNodePath = new StringBuffer();
        sysNodePath.append(nodePath);
        this.addNodeToList(listUserProfileList, sysNodePath, String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/UserProfile.xml");
        Collections.sort(listUserProfileList, Collections.reverseOrder());
        return listUserProfileList;
    }

    private void addNodeToList(List listUserOrSystem, StringBuffer sysNodePath, String filePath) {
        List listSystem = this.queryAPNInitParameter(sysNodePath.toString(), filePath);
        int i = 0;
        while (i < listSystem.size()) {
            APNEvent apnEvent = (APNEvent)listSystem.get(i);
            if (!"".equals(apnEvent.getNetworkName())) {
                listUserOrSystem.add(listSystem.get(i));
            }
            ++i;
        }
    }

    private List apnSort(List apnList) {
        HashMap<String, String> listName = new HashMap<String, String>();
        ArrayList<APNEvent> listFront = new ArrayList<APNEvent>();
        ArrayList<String> apnNameList = new ArrayList<String>();
        ArrayList<APNEvent> listAfter = new ArrayList<APNEvent>();
        int i = 0;
        while (i < apnList.size()) {
            APNEvent apnEvent = (APNEvent)apnList.get(i);
            listName.put(apnEvent.getNetworkName(), apnEvent.getNetworkName());
            ++i;
        }
        Iterator iterAPNName = listName.entrySet().iterator();
        while (iterAPNName.hasNext()) {
            boolean contentFlag = true;
            Map.Entry entry1 = iterAPNName.next();
            Object apnName = entry1.getValue();
            int j = 0;
            while (j < apnList.size()) {
                APNEvent apnEvent = (APNEvent)apnList.get(j);
                if (apnName.equals(apnEvent.getNetworkName()) && contentFlag) {
                    listFront.add(apnEvent);
                    contentFlag = false;
                }
                ++j;
            }
        }
        int tempSize = 0;
        tempSize = listFront.size() > 2048 ? 2048 : listFront.size();
        int i2 = 0;
        while (i2 < tempSize) {
            APNEvent apnEvent = (APNEvent)listFront.get(i2);
            apnNameList.add(apnEvent.getNetworkName());
            ++i2;
        }
        Collections.sort(apnNameList);
        i2 = 0;
        while (i2 < apnNameList.size()) {
            int j = 0;
            while (j < listFront.size()) {
                APNEvent apnEvent = (APNEvent)listFront.get(j);
                if (apnNameList.get(i2).toString().trim().equals(apnEvent.getNetworkName().trim())) {
                    listAfter.add(apnEvent);
                }
                ++j;
            }
            ++i2;
        }
        return listAfter;
    }
}

