/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.business.apn;

import com.huawei.mobilePartner.business.apn.APNEvent;
import com.huawei.mobilePartner.business.apn.ConfigParameter;
import com.huawei.mobilePartner.business.apn.InitializationAPN;
import com.huawei.mobilePartner.common.interfaces.ConfigInterface;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImportAPN {
    public LogConfig log = Log.getLog(ImportAPN.class);
    private static String configXmlPath = String.valueOf(Tools.getClassPath()) + "/";
    private final String dailupReqClose = "0";

    public ImportAPN() {
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\/", "/");
        configXmlPath = TextUtil.replaceStr1(configXmlPath, "\\", "/");
    }

    public List getImportAPNInfo(String filePath) {
        XMLTool.setImportExport(true);
        XMLTool comm = null;
        try {
            comm = new XMLTool(filePath);
        }
        catch (Exception ex) {
            this.log.info("update UserProfile.xml fail : [" + ex.toString() + "]");
        }
        String[] proName = ConfigInterface.APN_PROPERTIES_NAME;
        String cfgRequest = CustomizeInit.getCustomizeBean().getProfile_request_con();
        if (!"0".equals(cfgRequest)) {
            proName = ConfigInterface.APN_PROPERTIES_NAME_REQUEST;
        }
        List profileList = comm.quertyNodePropertiesValueByPath("utpsdoc/ProfileGroup[@type=\"DialUp\"]/Profile", proName);
        this.log.info("profileList : [" + profileList + "]");
        ArrayList<APNEvent> listNodeValue = new ArrayList<APNEvent>();
        int i = 0;
        while (i < profileList.size()) {
            HashMap profileMap = (HashMap)profileList.get(i);
            APNEvent apnEvent = new APNEvent();
            int j = 0;
            while (j < proName.length) {
                String strProValue = profileMap.get(proName[j]) == null ? "" : profileMap.get(proName[j]).toString();
                String attrName = proName[j];
                this.valueToAPNEvent(apnEvent, attrName, strProValue);
                ++j;
            }
            listNodeValue.add(apnEvent);
            ++i;
        }
        comm = null;
        return listNodeValue;
    }

    private void valueToAPNEvent(APNEvent apnEvent, String attrName, String strProValue) {
        this.log.debug(apnEvent.toString());
        if (attrName.equals("name")) {
            apnEvent.setNetworkName(strProValue);
        }
        if (attrName.equals("type")) {
            apnEvent.setProfType(strProValue);
        }
        if (attrName.equals("readonly")) {
            apnEvent.setReadOnly(strProValue);
        }
        if (attrName.equals("user")) {
            apnEvent.setUsername(strProValue);
        }
        if (attrName.equals("password")) {
            apnEvent.setPassword(strProValue);
        }
        if (attrName.equals("phonenumber")) {
            apnEvent.setPhoneNumber(strProValue);
        }
        if (attrName.equals("autoapn")) {
            apnEvent.setApnFlag(strProValue);
        }
        if (attrName.equals("apn")) {
            apnEvent.setApn(strProValue);
        }
        if (attrName.equals("chap")) {
            apnEvent.setChap(strProValue);
        }
        if (attrName.equals("ip")) {
            if ("".equals(strProValue)) {
                apnEvent.setIpFlag("true");
                apnEvent.setIp("");
            } else {
                apnEvent.setIpFlag("false");
                apnEvent.setIp(strProValue);
            }
        }
        if (attrName.equals("dns")) {
            if ("".equals(strProValue)) {
                apnEvent.setDnsFlag("true");
                apnEvent.setDnsPreferred(strProValue);
            } else {
                apnEvent.setDnsFlag("false");
                apnEvent.setDnsPreferred(strProValue);
            }
        }
        if (attrName.equals("dnsalt")) {
            apnEvent.setDnsStandby(strProValue);
        }
        if (attrName.equals("wins")) {
            if ("".equals(strProValue)) {
                apnEvent.setWinsFlag("true");
                apnEvent.setWinsPreferred(strProValue);
            } else {
                apnEvent.setWinsFlag("false");
                apnEvent.setWinsPreferred(strProValue);
            }
        }
        if (attrName.equals("winsalt")) {
            apnEvent.setWinsStandby(strProValue);
        }
        if (attrName.equals("request")) {
            apnEvent.setDialupRequest(strProValue);
        }
    }

    public List getImportAPNInfo() {
        InitializationAPN init = new InitializationAPN();
        List apnList = this.getAllProImportAPNInfo(String.valueOf(configXmlPath) + "config/data/ProfileLib.xml");
        List functionList = init.getApnParameter(init.packStrPath("Function/item"), ConfigInterface.FUNCTION_NAME);
        int index = 0;
        while (index < functionList.size()) {
            ConfigParameter config = (ConfigParameter)functionList.get(index);
            if (config.getName().trim().equalsIgnoreCase("ALLLIB")) {
                this.log.info("[" + config.getValue().trim().equalsIgnoreCase("true") + "]");
                apnList = config.getValue().trim().equalsIgnoreCase("true") ? this.getAllProImportAPNInfo("config/data/ProfileLib.xml") : this.getAllProImportAPNInfo("config/data/SysProfile.xml");
            }
            ++index;
        }
        return apnList;
    }

    public List getAllProImportAPNInfo(String xmlFilePath) {
        this.log.info("xmlFilePath : [" + xmlFilePath + "]");
        XMLTool comm = null;
        try {
            XMLTool.setImportExport(true);
            comm = new XMLTool(xmlFilePath);
        }
        catch (Exception ex) {
            this.log.info("import APN fail : [" + ex.toString() + "]");
        }
        String[] proName = ConfigInterface.APN_PROPERTIES_NAME;
        List profileList = comm.quertyNodePropertiesValueByPath("utpsdoc/ProfileGroup[@type=\"DialUp\"]/Profile", proName);
        ArrayList<APNEvent> listNodeValue = new ArrayList<APNEvent>();
        int i = 0;
        while (i < profileList.size()) {
            HashMap profileMap = (HashMap)profileList.get(i);
            APNEvent apnEvent = new APNEvent();
            int j = 0;
            while (j < proName.length) {
                String strProValue = profileMap.get(proName[j]) == null ? "" : profileMap.get(proName[j]).toString();
                String attrName = proName[j];
                this.valueToAPNEvent(apnEvent, attrName, strProValue);
                ++j;
            }
            listNodeValue.add(apnEvent);
            ++i;
        }
        comm = null;
        return listNodeValue;
    }
}

