#
# Win32 qconfig.mk file
#
BUILDENV := qss

override QNX_TARGET	:= $(shell '$(QNX_HOST)/usr/bin/canonical_dos_path.exe' '$(QNX_TARGET)')
override QNX_HOST	:= $(shell '$(QNX_HOST)/usr/bin/canonical_dos_path.exe' '$(QNX_HOST)')
ifneq ($(notdir $(patsubst %/,%,$(dir $(PWD)))), cygwin)
OS :=
endif

#
# The base directories for the installation trees.
#
INSTALL_ROOT_nto		:= $(QNX_TARGET)
INSTALL_ROOT_qnx4		:= /dev/null
INSTALL_ROOT_win32	:= /dev/null
INSTALL_ROOT_solaris	:= /dev/null

#
# The base directories for accessing headers/libraries for various OS's.
#
USE_ROOT_nto		:= $(QNX_TARGET)
USE_ROOT_qnx4		:= 
USE_ROOT_win32		:= 
USE_ROOT_solaris	:= /

MKFILES_ROOT := $(QNX_TARGET)/usr/include/mk

#
# The MG_HOST utilty is to "mark generated" any file that you'd normally
# consider a source file (something with a .c, .s, etc. extension),
# but is actually generated by a program. E.g., the kernel call
# source files in libc. It's purely for documentation purposes. 
#
MG_HOST = $(QNX_HOST)/usr/bin/true
#
# Copy a space separated list of files (possibly with wildcards) to an
# installation directory.
#
CP_HOST = $(QNX_HOST)/usr/bin/qnx_cp -vfpc $(CP_HOST_OPTIONS)
#
# Create a symbolic link.
#
LN_HOST = $(QNX_HOST)/usr/bin/ln-w -s $(LN_HOST_OPTIONS)
#
# Delete a space separated list of files (possibly with wildcards).
#
RM_HOST = $(QNX_HOST)/usr/bin/rm -f $(RM_HOST_OPTIONS)
#
# Create an empty file
#
TOUCH_HOST = $(QNX_HOST)/usr/bin/touch.exe
#
# Print the full path of the current working directory to standard output.
#
ifeq ($(WIN32_ENVIRON),cygwin)
PWD_HOST = $(QNX_HOST)/usr/bin/pwd.exe
else
# Note: on mingw based system, make must work with dos style paths
# (e.g. c:/dir/file) since the compiler is a win32 native application.
PWD_HOST = $(QNX_HOST)/usr/bin/pwd.exe -W
endif
#
# Generate a space separated list of files in a directory tree, ignoring
# anything in a CVS or RCS directory.
#
ifeq ($(WIN32_ENVIRON),cygwin)
FL_HOST = $(MKFILES_ROOT)/flist-win32
else
FL_HOST = sh $(MKFILES_ROOT)/flist-win32
endif
#
# Generate an assembler definition file from an object files.
#
MKASMOFF_HOST = $(QNX_HOST)/usr/bin/mkasmoff 
#
# Mark something as a privledged executable (setuid)
#
MP_HOST = $(MKFILES_ROOT)/makepriv-nt
#
# Echo text to the console
#
ECHO_HOST = $(QNX_HOST)/usr/bin/echo
HOST_HOST = hostname
DATE_HOST = $(QNX_HOST)/usr/bin/date +%Y/%m/%d-%H:%M:%S-%Z
USER_HOST = $(ECHO_HOST) $(USERNAME)


#
# CL_*	Compile and link
# CC_*	Compile C/C++ source to an object file
# AS_*	Assemble something to an object file
# AR_*  Generate an object file library (archive)
# LR_*  Link a list of objects/libraries to a relocatable object file
# LD_*  Link a list of objects/libraries to a executable/shared object
# UM_*	Add a usage message to an executable
# PB_*	Add PhAB resources to an executable using "phabbind"
#

#
# host system
#
CL_HOST = gcc
CC_HOST	= gcc -c
AS_HOST = gcc -c
AR_HOST = gcc -A
LD_HOST = gcc
UM_HOST = $(QNX_HOST)/usr/bin/usemsg
PB_HOST = $(QNX_HOST)/usr/bin/phabbind.exe

CD_nto = qcc
COMPILER_DRIVER = $(CD_$(OS))

dash:=-
comma:=,
gcc_ver_suffix=$(if $(GCC_VERSION),$(dash)$(GCC_VERSION))
gcc_ver_string=$(if $(GCC_VERSION),$(GCC_VERSION)$(comma))

#
# NTO X86 target 
#
CC_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-gcc$(gcc_ver_suffix) 
AS_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-gcc$(gcc_ver_suffix) 
AR_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-ar
LR_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-gcc$(gcc_ver_suffix) 
UM_nto_x86_gcc = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_x86_gcc = $(QNX_HOST)/usr/bin/ntox86-objcopy
LDBOOTSTRAP_nto_x86_gcc = $(QNX_HOST)/usr/bin/ldbootstrap -Bstatic -u_start
LDBOOTSTRAPPOST_nto_x86_gcc = -L$(USE_ROOT_nto)/x86/lib -lc $(shell $(CC_nto_x86_gcc) -print-libgcc-file-name)

CC_nto_x86_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntox86 -c
AS_nto_x86_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntox86 -c
LR_nto_x86_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntox86 -r -Bstatic
LD_nto_x86_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntox86
AR_nto_x86_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntox86 -a
UM_nto_x86_gcc_qcc = $(UM_nto_x86_gcc)
OC_nto_x86_gcc_qcc = $(OC_nto_x86_gcc)
LDBOOTSTRAP_nto_x86_gcc_qcc = $(LDBOOTSTRAP_nto_x86_gcc)
LDBOOTSTRAPPOST_nto_x86_gcc_qcc = $(LDBOOTSTRAPPOST_nto_x86_gcc)

CC_nto_x86_icc = icc -c
AS_nto_x86_icc = icc -c
LR_nto_x86_icc = icc -r
LD_nto_x86_icc = icc
AR_nto_x86_icc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86 -a
UM_nto_x86_icc = $(UM_nto_x86_gcc)
OC_nto_x86_icc = $(OC_nto_x86_gcc)
LDBOOTSTRAP_nto_x86_icc = $(LDBOOTSTRAP_nto_x86_gcc)
LDBOOTSTRAPPOST_nto_x86_icc = $(LDBOOTSTRAPPOST_nto_x86_gcc)

CC_nto_x86_icc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86 -c
AS_nto_x86_icc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86 -c
LR_nto_x86_icc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86 -r -Bstatic
LD_nto_x86_icc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86
AR_nto_x86_icc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)icc_ntox86 -a
UM_nto_x86_icc_qcc = $(UM_nto_x86_gcc)
OC_nto_x86_icc_qcc = $(OC_nto_x86_gcc)
LDBOOTSTRAP_nto_x86_icc_qcc = $(LDBOOTSTRAP_nto_x86_gcc)
LDBOOTSTRAPPOST_nto_x86_icc_qcc = $(LDBOOTSTRAPPOST_nto_x86_gcc)

#
# NTO PPC target 
#
CC_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-gcc$(gcc_ver_suffix) -c
AS_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-gcc$(gcc_ver_suffix) -c
AR_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-ar
LR_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-gcc$(gcc_ver_suffix) 
UM_nto_ppc_gcc = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_ppc_gcc = $(QNX_HOST)/usr/bin/ntoppc-objcopy

CC_nto_ppc_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoppc -c
AS_nto_ppc_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoppc -c
LR_nto_ppc_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoppc -r -Bstatic
LD_nto_ppc_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoppc
AR_nto_ppc_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoppc -a
UM_nto_ppc_gcc_qcc = $(UM_nto_ppc_gcc)
OC_nto_ppc_gcc_qcc = $(OC_nto_ppc_gcc)

#
# NTO MIPS target
#
CC_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-gcc$(gcc_ver_suffix) -c
AS_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-gcc$(gcc_ver_suffix) -c
AR_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-ar
LR_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-gcc$(gcc_ver_suffix) 
UM_nto_mips_gcc = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_mips_gcc = $(QNX_HOST)/usr/bin/ntomips-objcopy

CC_nto_mips_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntomips -c
AS_nto_mips_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntomips -c
LR_nto_mips_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntomips -r -Bstatic
LD_nto_mips_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntomips
AR_nto_mips_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntomips -a
UM_nto_mips_gcc_qcc = $(UM_nto_mips_gcc)
OC_nto_mips_gcc_qcc = $(OC_nto_mips_gcc)

#
# NTO ARM target
#
CC_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-gcc$(gcc_ver_suffix) -c
AS_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-gcc$(gcc_ver_suffix) -c
AR_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-ar
LR_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-gcc$(gcc_ver_suffix) 
UM_nto_arm_gcc = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_arm_gcc = $(QNX_HOST)/usr/bin/ntoarm-objcopy

CC_nto_arm_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarm -c
AS_nto_arm_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarm -c
LR_nto_arm_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarm -r -Bstatic
LD_nto_arm_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarm
AR_nto_arm_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarm -a
UM_nto_arm_gcc_qcc = $(UM_nto_arm_gcc)
OC_nto_arm_gcc_qcc = $(OC_nto_arm_gcc)

#
# NTO ARMv7 target
#
CC_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-gcc$(gcc_ver_suffix) -c
AS_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-gcc$(gcc_ver_suffix) -c
AR_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-ar
LR_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-gcc$(gcc_ver_suffix)
UM_nto_arm_gcc_v7 = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_arm_gcc_v7 = $(QNX_HOST)/usr/bin/ntoarmv7-objcopy

CC_nto_arm_gcc_qcc_v7 = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7 -c
AS_nto_arm_gcc_qcc_v7 = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7 -c
LR_nto_arm_gcc_qcc_v7 = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7 -r -Bstatic
LD_nto_arm_gcc_qcc_v7 = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7
AR_nto_arm_gcc_qcc_v7 = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7 -a
UM_nto_arm_gcc_qcc_v7 = $(UM_nto_arm_gcc_v7)
OC_nto_arm_gcc_qcc_v7 = $(OC_nto_arm_gcc_v7)

#
# NTO ARMv7hf target
#
CC_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-gcc$(gcc_ver_suffix) -c
AS_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-gcc$(gcc_ver_suffix) -c
AR_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-ar
LR_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-gcc$(gcc_ver_suffix)
UM_nto_arm_gcc_v7_hf = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_arm_gcc_v7_hf = $(QNX_HOST)/usr/bin/ntoarmv7hf-objcopy

CC_nto_arm_gcc_qcc_v7_hf = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7hf -c
AS_nto_arm_gcc_qcc_v7_hf = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7hf -c
LR_nto_arm_gcc_qcc_v7_hf = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7hf -r -Bstatic
LD_nto_arm_gcc_qcc_v7_hf = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7hf
AR_nto_arm_gcc_qcc_v7_hf = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntoarmv7hf -a
UM_nto_arm_gcc_qcc_v7_hf = $(UM_nto_arm_gcc_v7_hf)
OC_nto_arm_gcc_qcc_v7_hf = $(OC_nto_arm_gcc_v7_hf)

#
# NTO SH target
#
CC_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-gcc$(gcc_ver_suffix) -c
AS_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-gcc$(gcc_ver_suffix) -c
AR_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-ar
LR_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-gcc$(gcc_ver_suffix) -r -Bstatic
LD_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-gcc$(gcc_ver_suffix) 
UM_nto_sh_gcc = $(UM_HOST) -s __USAGENTO -s __USAGE
OC_nto_sh_gcc = $(QNX_HOST)/usr/bin/ntosh-objcopy

CC_nto_sh_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntosh -c
AS_nto_sh_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntosh -c
LR_nto_sh_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntosh -r -Bstatic
LD_nto_sh_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntosh
AR_nto_sh_gcc_qcc = $(QNX_HOST)/usr/bin/qcc -V$(gcc_ver_string)gcc_ntosh -a
UM_nto_sh_gcc_qcc = $(UM_nto_sh_gcc)
OC_nto_sh_gcc_qcc = $(OC_nto_sh_gcc)

#
# Win32 X86 targets
#
CC_win32_x86_gcc = gcc -c 
AS_win32_x86_gcc = gcc -c 
LR_win32_x86_gcc = gcc -r
LD_win32_x86_gcc = gcc 
AR_win32_x86_gcc = ar -r

CC_win32_x86_gcc_qcc = QNX_TARGET=`cygpath -w /` $(QNX_HOST)/usr/bin/qcc -c
AS_win32_x86_gcc_qcc = QNX_TARGET=`cygpath -w /` $(QNX_HOST)/usr/bin/qcc -c
LR_win32_x86_gcc_qcc = QNX_TARGET=`cygpath -w /` $(QNX_HOST)/usr/bin/qcc -r
LD_win32_x86_gcc_qcc = QNX_TARGET=`cygpath -w /` $(QNX_HOST)/usr/bin/qcc
AR_win32_x86_gcc_qcc = $(AR_win32_x86_gcc_gcc)

ifeq ($(WIN32_ENVIRON),mingw)
# Force the current dir to be represented with drive
# (e.g. c:/... instead of /c/...)
CWD := $(shell $(PWD_HOST))
CURDIR := $(CWD)
endif

ifndef QCONF_OVERRIDE

ifeq ($(WIN32_ENVIRON),cygwin)
CWD := $(shell $(PWD_HOST))
endif
roots:=$(filter $(ROOT_DIR) cvs src qssl, $(subst /, ,$(CWD)))
ifneq ($(roots),)
root:=$(word $(words $(roots)), $(roots))
src_root := $(patsubst %/,%,$(subst !,/,$(dir $(subst !$(root)!,!$(root)/, $(subst /,!, $(CWD))))))
QCONF_OVERRIDE=$(src_root)/qconf-override.mk
endif
endif
ifneq ($(QCONF_OVERRIDE),)
-include $(QCONF_OVERRIDE)
endif
